##manipulate and analyze phylogeny##
library(ape)
library(bio3d)
library(picante)

#read in rbcl tree ####
setwd("~/Dropbox/2018WorkingFiles/Admin/Courses/Courses_short/Build a phylogeny")

rbcl_tree<-read.tree("rbcl tree/rbcl_aligned.aln-fasta.contree")
#plot(rbcl_tree)

##make tree ultrametric####
rbcl_tree_UM<-chronopl(rbcl_tree,lambda=1,age.max=35)
#plot(rbcl_tree_root_UM)

##root the tree and remove BRIN####
rbcl_tree_root<-root(rbcl_tree_UM,"BRIN",resolve.root = TRUE)
rbcl_tree_root<-drop.tip(rbcl_tree_root,"BRIN")
#plot(rbcl_tree_root)

###look plotting options####
?plot.phylo

##plot and compare trees ####
quartz()
par(mfrow=c(1,3))
plot(rbcl_tree, cex = 1.5, main = "Raw tree", cex.main=1.5, edge.width = 1.5)
plot(rbcl_tree_UM, cex = 1.5, main = "Rooted tree", cex.main=1.5, edge.width = 1.5)
plot(rbcl_tree_root, cex = 1.5, main = "Ultrametric tree", cex.main=1.5, edge.width = 1.5)

#read in its1 tree ####
ITS1_tree<-read.tree("its1 tree/ITS1_aligned.aln-fasta.contree")
#plot(ITS1_tree)

##make tree ultrametric####
ITS1_tree_UM<-chronopl(ITS1_tree_root,lambda=1,age.max=35)
#plot(ITS1_tree_root_UM)

##root the tree ####
ITS1_tree_root<-root(ITS1_tree_UM,"BRIN")
ITS1_tree_root<-drop.tip(ITS1_tree_root,"BRIN")
#plot(ITS1_tree_root)



##plot and compare trees ####
quartz()
par(mfrow=c(1,3))
plot(ITS1_tree, cex = 1.5, main = "Raw tree", cex.main=1.5, edge.width = 1.5)
plot(ITS1_tree_UM, cex = 1.5, main = "Ultrametric tree", cex.main=1.5, edge.width = 1.5)
plot(ITS1_tree_root, cex = 1.5, main = "Rooted tree", cex.main=1.5, edge.width = 1.5)

#concatenate aligned files ##plot and compare trees ####

r<-read.dna("rbcl_aligned.aln-fasta",format="fasta")
I<-read.dna("ITS1_aligned.aln-fasta",format="fasta")
c.out<-cbind(r,I,fill.with.gaps=TRUE)
write.dna(c.out, "RBCL_ITS1.fas", format="fasta")

#run phylogeneticc analysis out side of R

##let's look at concatenated tree##plot and compare trees ####
Ctree<-read.tree("rbcl_its1/RBCL_ITS1.fas.contree")
#plot(Ctree)

##root the tree ####
Ctree_root<-root(Ctree,"BRIN")
#plot(Ctree_root)

##make tree ultrametric####
Ctree_root_UM<-chronopl(Ctree_root,lambda=1,age.max=35)
#plot(Ctree_root_UM)

##plot and compare trees ####
quartz()
par(mfrow=c(1,3))
plot(Ctree, cex = 1.5, main = "Raw tree", cex.main=1.5, edge.width = 1.5)
plot(Ctree_root, cex = 1.5, main = "Rooted tree", cex.main=1.5, edge.width = 1.5)
plot(Ctree_root_UM, cex = 1.5, main = "Ultrametric tree", 
     cex.main=1.5, edge.width = 1.5)

#examine parts of a tree ####
attributes(Ctree_root_UM)
Ctree_root_UM$edge
Ctree_root_UM$edge.length
Ctree_root_UM$Nnode
Ctree_root_UM$node.label

#let's trim the outgroup and plot the final tree ####
final_tree<-drop.tip(Ctree_root_UM,"BRIN")
quartz()
plot(final_tree, cex = 1.5, main = "Ultrametric tree", 
     cex.main=1.5, edge.width = 1.5,show.node.label = TRUE)


#do analyses!####
##read in trait data####
traits<-read.csv("trait.csv")


##phylogenetic signal####
trait1<-traits$Trait.1
names(trait1)<-traits$Species
#need to makes sure traits same order as tip labels
phylosignal(trait1[final_tree$tip.label],final_tree)

trait2<-traits$Trait.2
names(trait2)<-traits$Species
#need to makes sure traits same order as tip labels
phylosignal(trait2[final_tree$tip.label],final_tree)

## site data####
sites<-read.csv("sites.csv")
sites.M<-as.matrix(sites[,2:ncol(sites)])
rownames(sites.M)<-sites$Sites

ses.mpd(sites.M,cophenetic(final_tree))
